// SPDX-License-Identifier: GPL-2.0
/*-
 * Copyright(c) 2020-21 Intel Corporation. All rights reserved.
 */
#ifndef _IFC_MCDMA_BAS_H_
#define _IFC_MCDMA_BAS_H_

#include "ifc_mcdma_net.h"
#include "ifc_mcdma_ioctl.h"

/* BAS Addresses and offsets */
/* Read specific */
#define IFC_MCDMA_BAS_READ_ADDR				0x00000000UL
#define IFC_MCDMA_BAS_READ_COUNT			0x00000008UL
#define IFC_MCDMA_BAS_READ_ERR				0x00000010UL
#define IFC_MCDMA_BAS_READ_CTRL				0x00000018UL

#define IFC_MCDMA_BAS_READ_CTRL_TRANSFER_SIZE_SHIFT	0
#define IFC_MCDMA_BAS_READ_CTRL_TRANSFER_SIZE_WIDTH	8
#define IFC_MCDMA_BAS_READ_CTRL_TRANSFER_SIZE_MASK	0x0FFU

#define IFC_MCDMA_BAS_READ_CTRL_ENABLE_SHIFT		31
#define IFC_MCDMA_BAS_READ_CTRL_ENABLE_WIDTH		1
#define IFC_MCDMA_BAS_READ_CTRL_ENABLE_MASK		0x80000000UL

/* Write specific */
#define IFC_MCDMA_BAS_WRITE_ADDR			0x00000020UL
#define IFC_MCDMA_BAS_WRITE_COUNT			0x00000028UL
#define IFC_MCDMA_BAS_WRITE_ERR				0x00000030UL
#define IFC_MCDMA_BAS_WRITE_CTRL			0x00000038UL

#define IFC_MCDMA_BAS_WRITE_CTRL_TRANSFER_SIZE_SHIFT	0
#define IFC_MCDMA_BAS_WRITE_CTRL_TRANSFER_SIZE_WIDTH	8
#define IFC_MCDMA_BAS_WRITE_CTRL_TRANSFER_SIZE_MASK	0x0FFU

#define IFC_MCDMA_BAS_WRITE_CTRL_ENABLE_SHIFT		31
#define IFC_MCDMA_BAS_WRITE_CTRL_ENABLE_WIDTH		1
#define IFC_MCDMA_BAS_WRITE_CTRL_ENABLE_MASK		0x80000000UL

#define IFC_MCDMA_BAS_READ_MAP_TABLE			0x00000100UL
#define IFC_MCDMA_BAS_WRITE_MAP_TABLE			0x00000200UL

#define IFC_MCDMA_BAS_X16_SHIFT_WIDTH			0
#define IFC_MCDMA_BAS_X8_SHIFT_WIDTH			0

#define IFC_MCDMA_BAS_X16_BURST_LENGTH			8
#define IFC_MCDMA_BAS_X8_BURST_LENGTH			16
#define IFC_MCDMA_BAS_BURST_BYTES			512

#define IFC_MCDMA_BAS_TRANSFER_COUNT_MASK		0xFFFFFFFFUL
#define IFC_MCDMA_BAS_NON_STOP_TRANSFER_ENABLE_MASK	0x80000000UL
#define IFC_MCDMA_BAS_NON_STOP_TRANSFER_DISABLE_MASK	0x7FFFFFFFUL

int ifc_bas_transfer_handler(int dir, struct ifc_mcdma_dev_ctx *dev,
                             struct ifc_mcdma_netdev_priv_data *pd);
#endif /* _IFC_MCDMA_BAS_H_ */
